// Template Source: BaseEntityCollectionRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.ResourceSpecificPermissionGrant;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.requests.extensions.IResourceSpecificPermissionGrantCollectionPage;
import com.microsoft.graph.requests.extensions.ResourceSpecificPermissionGrantCollectionResponse;
import com.microsoft.graph.requests.extensions.IResourceSpecificPermissionGrantCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IResourceSpecificPermissionGrantCollectionRequest;
import com.microsoft.graph.requests.extensions.ResourceSpecificPermissionGrantCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Resource Specific Permission Grant Collection Request.
 */
public class ResourceSpecificPermissionGrantCollectionRequest extends BaseCollectionRequest<ResourceSpecificPermissionGrantCollectionResponse, IResourceSpecificPermissionGrantCollectionPage> implements IResourceSpecificPermissionGrantCollectionRequest {

    /**
     * The request builder for this collection of ResourceSpecificPermissionGrant
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ResourceSpecificPermissionGrantCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ResourceSpecificPermissionGrantCollectionResponse.class, IResourceSpecificPermissionGrantCollectionPage.class);
    }

    public void get(final ICallback<? super IResourceSpecificPermissionGrantCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IResourceSpecificPermissionGrantCollectionPage get() throws ClientException {
        final ResourceSpecificPermissionGrantCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final ResourceSpecificPermissionGrant newResourceSpecificPermissionGrant, final ICallback<? super ResourceSpecificPermissionGrant> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new ResourceSpecificPermissionGrantRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .post(newResourceSpecificPermissionGrant, callback);
    }

    public ResourceSpecificPermissionGrant post(final ResourceSpecificPermissionGrant newResourceSpecificPermissionGrant) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new ResourceSpecificPermissionGrantRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .post(newResourceSpecificPermissionGrant);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IResourceSpecificPermissionGrantCollectionRequest expand(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (ResourceSpecificPermissionGrantCollectionRequest)this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    public IResourceSpecificPermissionGrantCollectionRequest filter(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$filter", value));
        return (ResourceSpecificPermissionGrantCollectionRequest)this;
    }

    /**
     * Sets the order by clause for the request
     *
     * @param value the order by clause
     * @return the updated request
     */
    public IResourceSpecificPermissionGrantCollectionRequest orderBy(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$orderby", value));
        return (ResourceSpecificPermissionGrantCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IResourceSpecificPermissionGrantCollectionRequest select(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$select", value));
        return (ResourceSpecificPermissionGrantCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IResourceSpecificPermissionGrantCollectionRequest top(final int value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$top", value + ""));
        return (ResourceSpecificPermissionGrantCollectionRequest)this;
    }

    /**
     * Sets the skip value for the request
     *
     * @param value of the number of items to skip
     * @return the updated request
     */
    public IResourceSpecificPermissionGrantCollectionRequest skip(final int value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$skip", value + ""));
        return (ResourceSpecificPermissionGrantCollectionRequest)this;
    }


    /**
     * Add Skip token for pagination
     * @param skipToken - Token for pagination
     * @return the updated request
     */
    public IResourceSpecificPermissionGrantCollectionRequest skipToken(final String skipToken) {
    	addQueryOption(new QueryOption("$skiptoken", skipToken));
        return (IResourceSpecificPermissionGrantCollectionRequest)this;
    }
    public IResourceSpecificPermissionGrantCollectionPage buildFromResponse(final ResourceSpecificPermissionGrantCollectionResponse response) {
        final IResourceSpecificPermissionGrantCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new ResourceSpecificPermissionGrantCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final ResourceSpecificPermissionGrantCollectionPage page = new ResourceSpecificPermissionGrantCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
