// Template Source: BaseEntityReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.OrgContact;
import com.microsoft.graph.requests.extensions.IDirectoryObjectCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDirectoryObjectRequestBuilder;
import com.microsoft.graph.requests.extensions.DirectoryObjectCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DirectoryObjectRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.core.IBaseClient;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Org Contact Reference Request.
 */
public class OrgContactReferenceRequest extends BaseRequest implements IOrgContactReferenceRequest {

    /**
     * The request for the OrgContact
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OrgContactReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, OrgContact.class);
    }

    public void delete(final ICallback<? super OrgContact> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public OrgContact delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IOrgContactReferenceRequest select(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
        return (OrgContactReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IOrgContactReferenceRequest expand(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (OrgContactReferenceRequest)this;
    }
    /**
     * Puts the OrgContact
     *
     * @param srcOrgContact the OrgContact reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(OrgContact srcOrgContact, final ICallback<? super OrgContact> callback) {
        send(HttpMethod.PUT, callback, srcOrgContact);
    }

    /**
     * Puts the OrgContact
     *
     * @param srcOrgContact the OrgContact reference to PUT
     * @return the OrgContact
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public OrgContact put(OrgContact srcOrgContact) throws ClientException {
        return send(HttpMethod.PUT, srcOrgContact);
    }
}
