/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Place;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPlaceRequest;
import java.util.List;

public class PlaceRequest
extends BaseRequest
implements IPlaceRequest {
    public PlaceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<? extends Place> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    public PlaceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Place.class);
    }

    @Override
    public void get(ICallback<? super Place> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Place get() throws ClientException {
        return (Place)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Place> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Place sourcePlace, ICallback<? super Place> callback) {
        this.send(HttpMethod.PATCH, callback, sourcePlace);
    }

    @Override
    public Place patch(Place sourcePlace) throws ClientException {
        return (Place)this.send(HttpMethod.PATCH, sourcePlace);
    }

    @Override
    public void post(Place newPlace, ICallback<? super Place> callback) {
        this.send(HttpMethod.POST, callback, newPlace);
    }

    @Override
    public Place post(Place newPlace) throws ClientException {
        return (Place)this.send(HttpMethod.POST, newPlace);
    }

    @Override
    public void put(Place newPlace, ICallback<? super Place> callback) {
        this.send(HttpMethod.PUT, callback, newPlace);
    }

    @Override
    public Place put(Place newPlace) throws ClientException {
        return (Place)this.send(HttpMethod.PUT, newPlace);
    }

    @Override
    public IPlaceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPlaceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

