// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookWorksheet;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Worksheet Request.
 */
public interface IWorkbookWorksheetRequest extends IHttpRequest {

    /**
     * Gets the WorkbookWorksheet from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super WorkbookWorksheet> callback);

    /**
     * Gets the WorkbookWorksheet from the service
     *
     * @return the WorkbookWorksheet from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookWorksheet get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super WorkbookWorksheet> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookWorksheet with a source
     *
     * @param sourceWorkbookWorksheet the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WorkbookWorksheet sourceWorkbookWorksheet, final ICallback<? super WorkbookWorksheet> callback);

    /**
     * Patches this WorkbookWorksheet with a source
     *
     * @param sourceWorkbookWorksheet the source object with updates
     * @return the updated WorkbookWorksheet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookWorksheet patch(final WorkbookWorksheet sourceWorkbookWorksheet) throws ClientException;

    /**
     * Posts a WorkbookWorksheet with a new object
     *
     * @param newWorkbookWorksheet the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WorkbookWorksheet newWorkbookWorksheet, final ICallback<? super WorkbookWorksheet> callback);

    /**
     * Posts a WorkbookWorksheet with a new object
     *
     * @param newWorkbookWorksheet the new object to create
     * @return the created WorkbookWorksheet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookWorksheet post(final WorkbookWorksheet newWorkbookWorksheet) throws ClientException;

    /**
     * Posts a WorkbookWorksheet with a new object
     *
     * @param newWorkbookWorksheet the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final WorkbookWorksheet newWorkbookWorksheet, final ICallback<? super WorkbookWorksheet> callback);

    /**
     * Posts a WorkbookWorksheet with a new object
     *
     * @param newWorkbookWorksheet the object to create/update
     * @return the created WorkbookWorksheet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookWorksheet put(final WorkbookWorksheet newWorkbookWorksheet) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookWorksheetRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookWorksheetRequest expand(final String value);

}

