// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.WorkbookWorksheet;
import com.microsoft.graph.models.extensions.WorkbookChart;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.IWorkbookChartRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartCollectionRequest;
import com.microsoft.graph.requests.extensions.IWorkbookChartAddRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartCountRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartItemRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartItemAtRequestBuilder;
import com.microsoft.graph.http.IBaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Chart Collection Request Builder.
 */
public interface IWorkbookChartCollectionRequestBuilder extends IRequestBuilder {

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IUserRequest instance
     */
    IWorkbookChartCollectionRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions);

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IUserRequest instance
     */
    IWorkbookChartCollectionRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions);

    IWorkbookChartRequestBuilder byId(final String id);

    IWorkbookChartAddRequestBuilder add(final String type, final com.google.gson.JsonElement sourceData, final String seriesBy);
    IWorkbookChartCountRequestBuilder count();
    IWorkbookChartItemRequestBuilder item(final String name);
    IWorkbookChartItemAtRequestBuilder itemAt(final Integer index);
}
