// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.IosLobApp;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Ios Lob App Request.
 */
public interface IIosLobAppRequest extends IHttpRequest {

    /**
     * Gets the IosLobApp from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super IosLobApp> callback);

    /**
     * Gets the IosLobApp from the service
     *
     * @return the IosLobApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IosLobApp get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super IosLobApp> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this IosLobApp with a source
     *
     * @param sourceIosLobApp the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final IosLobApp sourceIosLobApp, final ICallback<? super IosLobApp> callback);

    /**
     * Patches this IosLobApp with a source
     *
     * @param sourceIosLobApp the source object with updates
     * @return the updated IosLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IosLobApp patch(final IosLobApp sourceIosLobApp) throws ClientException;

    /**
     * Posts a IosLobApp with a new object
     *
     * @param newIosLobApp the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final IosLobApp newIosLobApp, final ICallback<? super IosLobApp> callback);

    /**
     * Posts a IosLobApp with a new object
     *
     * @param newIosLobApp the new object to create
     * @return the created IosLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IosLobApp post(final IosLobApp newIosLobApp) throws ClientException;

    /**
     * Posts a IosLobApp with a new object
     *
     * @param newIosLobApp the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final IosLobApp newIosLobApp, final ICallback<? super IosLobApp> callback);

    /**
     * Posts a IosLobApp with a new object
     *
     * @param newIosLobApp the object to create/update
     * @return the created IosLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IosLobApp put(final IosLobApp newIosLobApp) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IIosLobAppRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IIosLobAppRequest expand(final String value);

}

