// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.HomeRealmDiscoveryPolicy;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.HomeRealmDiscoveryPolicy;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;


// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Home Realm Discovery Policy With Reference Request.
 */
public interface IHomeRealmDiscoveryPolicyWithReferenceRequest extends IHttpRequest {

    void post(final HomeRealmDiscoveryPolicy newHomeRealmDiscoveryPolicy, final IJsonBackedObject payload, final ICallback<? super HomeRealmDiscoveryPolicy> callback);

    HomeRealmDiscoveryPolicy post(final HomeRealmDiscoveryPolicy newHomeRealmDiscoveryPolicy, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<? super HomeRealmDiscoveryPolicy> callback);

    HomeRealmDiscoveryPolicy get() throws ClientException;

	void delete(final ICallback<? super HomeRealmDiscoveryPolicy> callback);

	void delete() throws ClientException;

	void patch(final HomeRealmDiscoveryPolicy sourceHomeRealmDiscoveryPolicy, final ICallback<? super HomeRealmDiscoveryPolicy> callback);

	HomeRealmDiscoveryPolicy patch(final HomeRealmDiscoveryPolicy sourceHomeRealmDiscoveryPolicy) throws ClientException;

    IHomeRealmDiscoveryPolicyWithReferenceRequest select(final String value);

    IHomeRealmDiscoveryPolicyWithReferenceRequest expand(final String value);

}
