// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.HomeRealmDiscoveryPolicy;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Home Realm Discovery Policy Request.
 */
public interface IHomeRealmDiscoveryPolicyRequest extends IHttpRequest {

    /**
     * Gets the HomeRealmDiscoveryPolicy from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super HomeRealmDiscoveryPolicy> callback);

    /**
     * Gets the HomeRealmDiscoveryPolicy from the service
     *
     * @return the HomeRealmDiscoveryPolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    HomeRealmDiscoveryPolicy get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super HomeRealmDiscoveryPolicy> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this HomeRealmDiscoveryPolicy with a source
     *
     * @param sourceHomeRealmDiscoveryPolicy the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final HomeRealmDiscoveryPolicy sourceHomeRealmDiscoveryPolicy, final ICallback<? super HomeRealmDiscoveryPolicy> callback);

    /**
     * Patches this HomeRealmDiscoveryPolicy with a source
     *
     * @param sourceHomeRealmDiscoveryPolicy the source object with updates
     * @return the updated HomeRealmDiscoveryPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    HomeRealmDiscoveryPolicy patch(final HomeRealmDiscoveryPolicy sourceHomeRealmDiscoveryPolicy) throws ClientException;

    /**
     * Posts a HomeRealmDiscoveryPolicy with a new object
     *
     * @param newHomeRealmDiscoveryPolicy the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final HomeRealmDiscoveryPolicy newHomeRealmDiscoveryPolicy, final ICallback<? super HomeRealmDiscoveryPolicy> callback);

    /**
     * Posts a HomeRealmDiscoveryPolicy with a new object
     *
     * @param newHomeRealmDiscoveryPolicy the new object to create
     * @return the created HomeRealmDiscoveryPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    HomeRealmDiscoveryPolicy post(final HomeRealmDiscoveryPolicy newHomeRealmDiscoveryPolicy) throws ClientException;

    /**
     * Posts a HomeRealmDiscoveryPolicy with a new object
     *
     * @param newHomeRealmDiscoveryPolicy the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final HomeRealmDiscoveryPolicy newHomeRealmDiscoveryPolicy, final ICallback<? super HomeRealmDiscoveryPolicy> callback);

    /**
     * Posts a HomeRealmDiscoveryPolicy with a new object
     *
     * @param newHomeRealmDiscoveryPolicy the object to create/update
     * @return the created HomeRealmDiscoveryPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    HomeRealmDiscoveryPolicy put(final HomeRealmDiscoveryPolicy newHomeRealmDiscoveryPolicy) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IHomeRealmDiscoveryPolicyRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IHomeRealmDiscoveryPolicyRequest expand(final String value);

}

