// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.HomeRealmDiscoveryPolicy;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.HomeRealmDiscoveryPolicy;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Home Realm Discovery Policy Reference Request.
 */
public interface IHomeRealmDiscoveryPolicyReferenceRequest extends IHttpRequest {

    void delete(final ICallback<? super HomeRealmDiscoveryPolicy> callback);

    HomeRealmDiscoveryPolicy delete() throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IHomeRealmDiscoveryPolicyReferenceRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IHomeRealmDiscoveryPolicyReferenceRequest expand(final String value);

    /**
     * Puts the HomeRealmDiscoveryPolicy
     *
     * @param srcHomeRealmDiscoveryPolicy the HomeRealmDiscoveryPolicy to PUT
     * @param callback the callback to be called after success or failure
     */
    void put(HomeRealmDiscoveryPolicy srcHomeRealmDiscoveryPolicy, final ICallback<? super HomeRealmDiscoveryPolicy> callback);

    /**
     * Puts the HomeRealmDiscoveryPolicy
     *
     * @param srcHomeRealmDiscoveryPolicy the HomeRealmDiscoveryPolicy to PUT
     * @return the HomeRealmDiscoveryPolicy
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    HomeRealmDiscoveryPolicy put(HomeRealmDiscoveryPolicy srcHomeRealmDiscoveryPolicy) throws ClientException;
}
