// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ConditionalAccessPolicy;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Conditional Access Policy Request.
 */
public interface IConditionalAccessPolicyRequest extends IHttpRequest {

    /**
     * Gets the ConditionalAccessPolicy from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super ConditionalAccessPolicy> callback);

    /**
     * Gets the ConditionalAccessPolicy from the service
     *
     * @return the ConditionalAccessPolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ConditionalAccessPolicy get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super ConditionalAccessPolicy> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ConditionalAccessPolicy with a source
     *
     * @param sourceConditionalAccessPolicy the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ConditionalAccessPolicy sourceConditionalAccessPolicy, final ICallback<? super ConditionalAccessPolicy> callback);

    /**
     * Patches this ConditionalAccessPolicy with a source
     *
     * @param sourceConditionalAccessPolicy the source object with updates
     * @return the updated ConditionalAccessPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ConditionalAccessPolicy patch(final ConditionalAccessPolicy sourceConditionalAccessPolicy) throws ClientException;

    /**
     * Posts a ConditionalAccessPolicy with a new object
     *
     * @param newConditionalAccessPolicy the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ConditionalAccessPolicy newConditionalAccessPolicy, final ICallback<? super ConditionalAccessPolicy> callback);

    /**
     * Posts a ConditionalAccessPolicy with a new object
     *
     * @param newConditionalAccessPolicy the new object to create
     * @return the created ConditionalAccessPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ConditionalAccessPolicy post(final ConditionalAccessPolicy newConditionalAccessPolicy) throws ClientException;

    /**
     * Posts a ConditionalAccessPolicy with a new object
     *
     * @param newConditionalAccessPolicy the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ConditionalAccessPolicy newConditionalAccessPolicy, final ICallback<? super ConditionalAccessPolicy> callback);

    /**
     * Posts a ConditionalAccessPolicy with a new object
     *
     * @param newConditionalAccessPolicy the object to create/update
     * @return the created ConditionalAccessPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ConditionalAccessPolicy put(final ConditionalAccessPolicy newConditionalAccessPolicy) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IConditionalAccessPolicyRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IConditionalAccessPolicyRequest expand(final String value);

}

