// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.CloudCommunications;
import com.microsoft.graph.models.extensions.Presence;
import com.microsoft.graph.requests.extensions.ICallCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ICallRequestBuilder;
import com.microsoft.graph.callrecords.requests.extensions.ICallRecordCollectionRequestBuilder;
import com.microsoft.graph.callrecords.requests.extensions.ICallRecordRequestBuilder;
import com.microsoft.graph.requests.extensions.IOnlineMeetingCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IOnlineMeetingRequestBuilder;
import com.microsoft.graph.requests.extensions.IPresenceCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPresenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Cloud Communications Request Builder.
 */
public interface ICloudCommunicationsRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the ICloudCommunicationsRequest instance
     */
    ICloudCommunicationsRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions);

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the ICloudCommunicationsRequest instance
     */
    ICloudCommunicationsRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions);


    ICallCollectionRequestBuilder calls();

    ICallRequestBuilder calls(final String id);

    ICallRecordCollectionRequestBuilder callRecords();

    ICallRecordRequestBuilder callRecords(final String id);

    IOnlineMeetingCollectionRequestBuilder onlineMeetings();

    IOnlineMeetingRequestBuilder onlineMeetings(final String id);

    IPresenceCollectionRequestBuilder presences();

    IPresenceRequestBuilder presences(final String id);

    ICloudCommunicationsGetPresencesByUserIdCollectionRequestBuilder getPresencesByUserId(final java.util.List<String> ids);

}