// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ChangeTrackedEntity;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Change Tracked Entity Request.
 */
public interface IChangeTrackedEntityRequest extends IHttpRequest {

    /**
     * Gets the ChangeTrackedEntity from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super ChangeTrackedEntity> callback);

    /**
     * Gets the ChangeTrackedEntity from the service
     *
     * @return the ChangeTrackedEntity from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ChangeTrackedEntity get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super ChangeTrackedEntity> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ChangeTrackedEntity with a source
     *
     * @param sourceChangeTrackedEntity the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ChangeTrackedEntity sourceChangeTrackedEntity, final ICallback<? super ChangeTrackedEntity> callback);

    /**
     * Patches this ChangeTrackedEntity with a source
     *
     * @param sourceChangeTrackedEntity the source object with updates
     * @return the updated ChangeTrackedEntity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ChangeTrackedEntity patch(final ChangeTrackedEntity sourceChangeTrackedEntity) throws ClientException;

    /**
     * Posts a ChangeTrackedEntity with a new object
     *
     * @param newChangeTrackedEntity the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ChangeTrackedEntity newChangeTrackedEntity, final ICallback<? super ChangeTrackedEntity> callback);

    /**
     * Posts a ChangeTrackedEntity with a new object
     *
     * @param newChangeTrackedEntity the new object to create
     * @return the created ChangeTrackedEntity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ChangeTrackedEntity post(final ChangeTrackedEntity newChangeTrackedEntity) throws ClientException;

    /**
     * Posts a ChangeTrackedEntity with a new object
     *
     * @param newChangeTrackedEntity the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ChangeTrackedEntity newChangeTrackedEntity, final ICallback<? super ChangeTrackedEntity> callback);

    /**
     * Posts a ChangeTrackedEntity with a new object
     *
     * @param newChangeTrackedEntity the object to create/update
     * @return the created ChangeTrackedEntity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ChangeTrackedEntity put(final ChangeTrackedEntity newChangeTrackedEntity) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IChangeTrackedEntityRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IChangeTrackedEntityRequest expand(final String value);

}

