// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.AadUserConversationMember;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Aad User Conversation Member Request.
 */
public interface IAadUserConversationMemberRequest extends IHttpRequest {

    /**
     * Gets the AadUserConversationMember from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super AadUserConversationMember> callback);

    /**
     * Gets the AadUserConversationMember from the service
     *
     * @return the AadUserConversationMember from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AadUserConversationMember get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super AadUserConversationMember> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this AadUserConversationMember with a source
     *
     * @param sourceAadUserConversationMember the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final AadUserConversationMember sourceAadUserConversationMember, final ICallback<? super AadUserConversationMember> callback);

    /**
     * Patches this AadUserConversationMember with a source
     *
     * @param sourceAadUserConversationMember the source object with updates
     * @return the updated AadUserConversationMember
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AadUserConversationMember patch(final AadUserConversationMember sourceAadUserConversationMember) throws ClientException;

    /**
     * Posts a AadUserConversationMember with a new object
     *
     * @param newAadUserConversationMember the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final AadUserConversationMember newAadUserConversationMember, final ICallback<? super AadUserConversationMember> callback);

    /**
     * Posts a AadUserConversationMember with a new object
     *
     * @param newAadUserConversationMember the new object to create
     * @return the created AadUserConversationMember
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AadUserConversationMember post(final AadUserConversationMember newAadUserConversationMember) throws ClientException;

    /**
     * Posts a AadUserConversationMember with a new object
     *
     * @param newAadUserConversationMember the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final AadUserConversationMember newAadUserConversationMember, final ICallback<? super AadUserConversationMember> callback);

    /**
     * Posts a AadUserConversationMember with a new object
     *
     * @param newAadUserConversationMember the object to create/update
     * @return the created AadUserConversationMember
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AadUserConversationMember put(final AadUserConversationMember newAadUserConversationMember) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IAadUserConversationMemberRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IAadUserConversationMemberRequest expand(final String value);

}

