// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Presence;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.ICloudCommunicationsGetPresencesByUserIdCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.CloudCommunicationsGetPresencesByUserIdCollectionPage;
import com.microsoft.graph.requests.extensions.CloudCommunicationsGetPresencesByUserIdCollectionResponse;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.IBaseCollectionPage;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Cloud Communications Get Presences By User Id Collection Page.
 */
public class CloudCommunicationsGetPresencesByUserIdCollectionPage extends BaseCollectionPage<Presence, ICloudCommunicationsGetPresencesByUserIdCollectionRequestBuilder> implements ICloudCommunicationsGetPresencesByUserIdCollectionPage {

    /**
     * A collection page for Presence.
     *
     * @param response The serialized CloudCommunicationsGetPresencesByUserIdCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public CloudCommunicationsGetPresencesByUserIdCollectionPage(final CloudCommunicationsGetPresencesByUserIdCollectionResponse response, final ICloudCommunicationsGetPresencesByUserIdCollectionRequestBuilder builder) {
       super(response.value, builder, response.additionalDataManager());
    }
}
