// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.generated;


/**
 * The Enum Security Network Protocol.
*/
public enum SecurityNetworkProtocol
{
    /**
    * unknown
    */
    UNKNOWN,
    /**
    * ip
    */
    IP,
    /**
    * icmp
    */
    ICMP,
    /**
    * igmp
    */
    IGMP,
    /**
    * ggp
    */
    GGP,
    /**
    * ipv4
    */
    IPV4,
    /**
    * tcp
    */
    TCP,
    /**
    * pup
    */
    PUP,
    /**
    * udp
    */
    UDP,
    /**
    * idp
    */
    IDP,
    /**
    * ipv6
    */
    IPV6,
    /**
    * ipv6Routing Header
    */
    IPV6_ROUTING_HEADER,
    /**
    * ipv6Fragment Header
    */
    IPV6_FRAGMENT_HEADER,
    /**
    * ip Sec Encapsulating Security Payload
    */
    IP_SEC_ENCAPSULATING_SECURITY_PAYLOAD,
    /**
    * ip Sec Authentication Header
    */
    IP_SEC_AUTHENTICATION_HEADER,
    /**
    * icmp V6
    */
    ICMP_V6,
    /**
    * ipv6No Next Header
    */
    IPV6_NO_NEXT_HEADER,
    /**
    * ipv6Destination Options
    */
    IPV6_DESTINATION_OPTIONS,
    /**
    * nd
    */
    ND,
    /**
    * raw
    */
    RAW,
    /**
    * ipx
    */
    IPX,
    /**
    * spx
    */
    SPX,
    /**
    * spx II
    */
    SPX_II,
    /**
    * unknown Future Value
    */
    UNKNOWN_FUTURE_VALUE,
    /**
    * For SecurityNetworkProtocol values that were not expected from the service
    */
    UNEXPECTED_VALUE
}
