// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.generated.Win32LobAppMsiPackageType;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Win32Lob App Msi Information.
 */
public class Win32LobAppMsiInformation implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Package Type.
     * The MSI package type. Possible values are: perMachine, perUser, dualPurpose.
     */
    @SerializedName(value = "packageType", alternate = {"PackageType"})
    @Expose
    public Win32LobAppMsiPackageType packageType;

    /**
     * The Product Code.
     * The MSI product code.
     */
    @SerializedName(value = "productCode", alternate = {"ProductCode"})
    @Expose
    public String productCode;

    /**
     * The Product Name.
     * The MSI product name.
     */
    @SerializedName(value = "productName", alternate = {"ProductName"})
    @Expose
    public String productName;

    /**
     * The Product Version.
     * The MSI product version.
     */
    @SerializedName(value = "productVersion", alternate = {"ProductVersion"})
    @Expose
    public String productVersion;

    /**
     * The Publisher.
     * The MSI publisher.
     */
    @SerializedName(value = "publisher", alternate = {"Publisher"})
    @Expose
    public String publisher;

    /**
     * The Requires Reboot.
     * Whether the MSI app requires the machine to reboot to complete installation.
     */
    @SerializedName(value = "requiresReboot", alternate = {"RequiresReboot"})
    @Expose
    public Boolean requiresReboot;

    /**
     * The Upgrade Code.
     * The MSI upgrade code.
     */
    @SerializedName(value = "upgradeCode", alternate = {"UpgradeCode"})
    @Expose
    public String upgradeCode;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
