// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.Recipient;
import com.microsoft.graph.models.extensions.ItemBody;
import com.microsoft.graph.models.extensions.FollowupFlag;
import com.microsoft.graph.models.generated.Importance;
import com.microsoft.graph.models.generated.InferenceClassificationType;
import com.microsoft.graph.models.extensions.InternetMessageHeader;
import com.microsoft.graph.models.extensions.Attachment;
import com.microsoft.graph.models.extensions.Extension;
import com.microsoft.graph.models.extensions.MultiValueLegacyExtendedProperty;
import com.microsoft.graph.models.extensions.SingleValueLegacyExtendedProperty;
import com.microsoft.graph.models.extensions.OutlookItem;
import com.microsoft.graph.requests.extensions.AttachmentCollectionPage;
import com.microsoft.graph.requests.extensions.ExtensionCollectionPage;
import com.microsoft.graph.requests.extensions.MultiValueLegacyExtendedPropertyCollectionPage;
import com.microsoft.graph.requests.extensions.SingleValueLegacyExtendedPropertyCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Message.
 */
public class Message extends OutlookItem implements IJsonBackedObject {


    /**
     * The Bcc Recipients.
     * The Bcc: recipients for the message.
     */
    @SerializedName(value = "bccRecipients", alternate = {"BccRecipients"})
    @Expose
    public java.util.List<Recipient> bccRecipients;

    /**
     * The Body.
     * The body of the message. It can be in HTML or text format. Find out about safe HTML in a message body.
     */
    @SerializedName(value = "body", alternate = {"Body"})
    @Expose
    public ItemBody body;

    /**
     * The Body Preview.
     * The first 255 characters of the message body. It is in text format.
     */
    @SerializedName(value = "bodyPreview", alternate = {"BodyPreview"})
    @Expose
    public String bodyPreview;

    /**
     * The Cc Recipients.
     * The Cc: recipients for the message.
     */
    @SerializedName(value = "ccRecipients", alternate = {"CcRecipients"})
    @Expose
    public java.util.List<Recipient> ccRecipients;

    /**
     * The Conversation Id.
     * The ID of the conversation the email belongs to.
     */
    @SerializedName(value = "conversationId", alternate = {"ConversationId"})
    @Expose
    public String conversationId;

    /**
     * The Conversation Index.
     * Indicates the position of the message within the conversation.
     */
    @SerializedName(value = "conversationIndex", alternate = {"ConversationIndex"})
    @Expose
    public byte[] conversationIndex;

    /**
     * The Flag.
     * The flag value that indicates the status, start date, due date, or completion date for the message.
     */
    @SerializedName(value = "flag", alternate = {"Flag"})
    @Expose
    public FollowupFlag flag;

    /**
     * The From.
     * The owner of the mailbox from which the message is sent. In most cases, this value is the same as the sender property, except for sharing or delegation scenarios. The value must correspond to the actual mailbox used. Find out more about setting the from and sender properties of a message.
     */
    @SerializedName(value = "from", alternate = {"From"})
    @Expose
    public Recipient from;

    /**
     * The Has Attachments.
     * Indicates whether the message has attachments. This property doesn't include inline attachments, so if a message contains only inline attachments, this property is false. To verify the existence of inline attachments, parse the body property to look for a src attribute, such as &amp;lt;IMG src='cid:image001.jpg@01D26CD8.6C05F070'&amp;gt;.
     */
    @SerializedName(value = "hasAttachments", alternate = {"HasAttachments"})
    @Expose
    public Boolean hasAttachments;

    /**
     * The Importance.
     * The importance of the message: Low, Normal, High.
     */
    @SerializedName(value = "importance", alternate = {"Importance"})
    @Expose
    public Importance importance;

    /**
     * The Inference Classification.
     * The classification of the message for the user, based on inferred relevance or importance, or on an explicit override. The possible values are: focused or other.
     */
    @SerializedName(value = "inferenceClassification", alternate = {"InferenceClassification"})
    @Expose
    public InferenceClassificationType inferenceClassification;

    /**
     * The Internet Message Headers.
     * A collection of message headers defined by RFC5322. The set includes message headers indicating the network path taken by a message from the sender to the recipient. It can also contain custom message headers that hold app data for the message.  Returned only on applying a $select query option. Read-only.
     */
    @SerializedName(value = "internetMessageHeaders", alternate = {"InternetMessageHeaders"})
    @Expose
    public java.util.List<InternetMessageHeader> internetMessageHeaders;

    /**
     * The Internet Message Id.
     * The message ID in the format specified by RFC2822.
     */
    @SerializedName(value = "internetMessageId", alternate = {"InternetMessageId"})
    @Expose
    public String internetMessageId;

    /**
     * The Is Delivery Receipt Requested.
     * Indicates whether a read receipt is requested for the message.
     */
    @SerializedName(value = "isDeliveryReceiptRequested", alternate = {"IsDeliveryReceiptRequested"})
    @Expose
    public Boolean isDeliveryReceiptRequested;

    /**
     * The Is Draft.
     * Indicates whether the message is a draft. A message is a draft if it hasn't been sent yet.
     */
    @SerializedName(value = "isDraft", alternate = {"IsDraft"})
    @Expose
    public Boolean isDraft;

    /**
     * The Is Read.
     * Indicates whether the message has been read.
     */
    @SerializedName(value = "isRead", alternate = {"IsRead"})
    @Expose
    public Boolean isRead;

    /**
     * The Is Read Receipt Requested.
     * Indicates whether a read receipt is requested for the message.
     */
    @SerializedName(value = "isReadReceiptRequested", alternate = {"IsReadReceiptRequested"})
    @Expose
    public Boolean isReadReceiptRequested;

    /**
     * The Parent Folder Id.
     * The unique identifier for the message's parent mailFolder.
     */
    @SerializedName(value = "parentFolderId", alternate = {"ParentFolderId"})
    @Expose
    public String parentFolderId;

    /**
     * The Received Date Time.
     * The date and time the message was received.  The date and time information uses ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     */
    @SerializedName(value = "receivedDateTime", alternate = {"ReceivedDateTime"})
    @Expose
    public java.util.Calendar receivedDateTime;

    /**
     * The Reply To.
     * The email addresses to use when replying.
     */
    @SerializedName(value = "replyTo", alternate = {"ReplyTo"})
    @Expose
    public java.util.List<Recipient> replyTo;

    /**
     * The Sender.
     * The account that is actually used to generate the message. In most cases, this value is the same as the from property. You can set this property to a different value when sending a message from a shared mailbox, for a shared calendar, or as a delegate. In any case, the value must correspond to the actual mailbox used. Find out more about setting the from and sender properties of a message.
     */
    @SerializedName(value = "sender", alternate = {"Sender"})
    @Expose
    public Recipient sender;

    /**
     * The Sent Date Time.
     * The date and time the message was sent.  The date and time information uses ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     */
    @SerializedName(value = "sentDateTime", alternate = {"SentDateTime"})
    @Expose
    public java.util.Calendar sentDateTime;

    /**
     * The Subject.
     * The subject of the message.
     */
    @SerializedName(value = "subject", alternate = {"Subject"})
    @Expose
    public String subject;

    /**
     * The To Recipients.
     * The To: recipients for the message.
     */
    @SerializedName(value = "toRecipients", alternate = {"ToRecipients"})
    @Expose
    public java.util.List<Recipient> toRecipients;

    /**
     * The Unique Body.
     * The part of the body of the message that is unique to the current message. uniqueBody is not returned by default but can be retrieved for a given message by use of the ?$select=uniqueBody query. It can be in HTML or text format.
     */
    @SerializedName(value = "uniqueBody", alternate = {"UniqueBody"})
    @Expose
    public ItemBody uniqueBody;

    /**
     * The Web Link.
     * The URL to open the message in Outlook on the web.You can append an ispopout argument to the end of the URL to change how the message is displayed. If ispopout is not present or if it is set to 1, then the message is shown in a popout window. If ispopout is set to 0, then the browser will show the message in the Outlook on the web review pane.The message will open in the browser if you are logged in to your mailbox via Outlook on the web. You will be prompted to login if you are not already logged in with the browser.This URL cannot be accessed from within an iFrame.
     */
    @SerializedName(value = "webLink", alternate = {"WebLink"})
    @Expose
    public String webLink;

    /**
     * The Attachments.
     * The fileAttachment and itemAttachment attachments for the message.
     */
    @SerializedName(value = "attachments", alternate = {"Attachments"})
    @Expose
    public AttachmentCollectionPage attachments;

    /**
     * The Extensions.
     * The collection of open extensions defined for the message. Nullable.
     */
    @SerializedName(value = "extensions", alternate = {"Extensions"})
    @Expose
    public ExtensionCollectionPage extensions;

    /**
     * The Multi Value Extended Properties.
     * The collection of multi-value extended properties defined for the message. Nullable.
     */
    @SerializedName(value = "multiValueExtendedProperties", alternate = {"MultiValueExtendedProperties"})
    @Expose
    public MultiValueLegacyExtendedPropertyCollectionPage multiValueExtendedProperties;

    /**
     * The Single Value Extended Properties.
     * The collection of single-value extended properties defined for the message. Nullable.
     */
    @SerializedName(value = "singleValueExtendedProperties", alternate = {"SingleValueExtendedProperties"})
    @Expose
    public SingleValueLegacyExtendedPropertyCollectionPage singleValueExtendedProperties;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("attachments")) {
            attachments = serializer.deserializeObject(json.get("attachments").toString(), AttachmentCollectionPage.class);
        }

        if (json.has("extensions")) {
            extensions = serializer.deserializeObject(json.get("extensions").toString(), ExtensionCollectionPage.class);
        }

        if (json.has("multiValueExtendedProperties")) {
            multiValueExtendedProperties = serializer.deserializeObject(json.get("multiValueExtendedProperties").toString(), MultiValueLegacyExtendedPropertyCollectionPage.class);
        }

        if (json.has("singleValueExtendedProperties")) {
            singleValueExtendedProperties = serializer.deserializeObject(json.get("singleValueExtendedProperties").toString(), SingleValueLegacyExtendedPropertyCollectionPage.class);
        }
    }
}
