// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.callrecords.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.callrecords.models.extensions.DeviceInfo;
import com.microsoft.graph.callrecords.models.extensions.NetworkInfo;
import com.microsoft.graph.callrecords.models.extensions.MediaStream;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Media.
 */
public class Media implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Callee Device.
     * Device information associated with the callee endpoint of this media.
     */
    @SerializedName(value = "calleeDevice", alternate = {"CalleeDevice"})
    @Expose
    public DeviceInfo calleeDevice;

    /**
     * The Callee Network.
     * Network information associated with the callee endpoint of this media.
     */
    @SerializedName(value = "calleeNetwork", alternate = {"CalleeNetwork"})
    @Expose
    public NetworkInfo calleeNetwork;

    /**
     * The Caller Device.
     * Device information associated with the caller endpoint of this media.
     */
    @SerializedName(value = "callerDevice", alternate = {"CallerDevice"})
    @Expose
    public DeviceInfo callerDevice;

    /**
     * The Caller Network.
     * Network information associated with the caller endpoint of this media.
     */
    @SerializedName(value = "callerNetwork", alternate = {"CallerNetwork"})
    @Expose
    public NetworkInfo callerNetwork;

    /**
     * The Label.
     * How the media was identified during media negotiation stage.
     */
    @SerializedName(value = "label", alternate = {"Label"})
    @Expose
    public String label;

    /**
     * The Streams.
     * Network streams associated with this media.
     */
    @SerializedName(value = "streams", alternate = {"Streams"})
    @Expose
    public java.util.List<MediaStream> streams;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
