// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookSessionInfoResourceRequest;
import com.microsoft.graph.requests.extensions.WorkbookSessionInfoResourceRequest;
import com.microsoft.graph.models.extensions.WorkbookSessionInfo;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Session Info Resource Request Builder.
 */
public class WorkbookSessionInfoResourceRequestBuilder extends BaseFunctionRequestBuilder implements IWorkbookSessionInfoResourceRequestBuilder {

    /**
     * The request builder for this WorkbookSessionInfoResource
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param key the key
     */
    public WorkbookSessionInfoResourceRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final String key) {
        super(requestUrl, client, requestOptions);
        functionOptions.add(new com.microsoft.graph.options.FunctionOption("key", key));
    }

    /**
     * Creates the IWorkbookSessionInfoResourceRequest
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookSessionInfoResourceRequest instance
     */
    public IWorkbookSessionInfoResourceRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IWorkbookSessionInfoResourceRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookSessionInfoResourceRequest instance
     */
    public IWorkbookSessionInfoResourceRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        WorkbookSessionInfoResourceRequest request = new WorkbookSessionInfoResourceRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

      for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
            request.addFunctionOption(option);
      }

        return request;
    }
}
