// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookFunctionsMroundRequest;
import com.microsoft.graph.requests.extensions.WorkbookFunctionsMroundRequest;
import com.microsoft.graph.models.extensions.WorkbookFunctionResult;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Mround Request Builder.
 */
public class WorkbookFunctionsMroundRequestBuilder extends BaseActionRequestBuilder implements IWorkbookFunctionsMroundRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsMround
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param number the number
     * @param multiple the multiple
     */
    public WorkbookFunctionsMroundRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final com.google.gson.JsonElement number, final com.google.gson.JsonElement multiple) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("number", number);
        bodyParams.put("multiple", multiple);
    }

    /**
     * Creates the IWorkbookFunctionsMroundRequest
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookFunctionsMroundRequest instance
     */
    public IWorkbookFunctionsMroundRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IWorkbookFunctionsMroundRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookFunctionsMroundRequest instance
     */
    public IWorkbookFunctionsMroundRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        WorkbookFunctionsMroundRequest request = new WorkbookFunctionsMroundRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("number")) {
            request.body.number = getParameter("number");
        }

        if (hasParameter("multiple")) {
            request.body.multiple = getParameter("multiple");
        }

        return request;
    }
}
