// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookChartPoint;
import com.microsoft.graph.requests.extensions.IWorkbookChartPointItemAtRequest;
import com.microsoft.graph.requests.extensions.WorkbookChartPointItemAtRequest;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Point Item At Request.
 */
public class WorkbookChartPointItemAtRequest extends BaseRequest implements IWorkbookChartPointItemAtRequest {

    /**
     * The request for this WorkbookChartPointItemAt
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookChartPointItemAtRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookChartPoint.class);
    }

    /**
     * Patches the WorkbookChartPointItemAt
     * @param srcWorkbookChartPoint the WorkbookChartPoint with which to PATCH
     * @param callback the callback to be called after success or failure
     */
    public void patch(WorkbookChartPoint srcWorkbookChartPoint, final ICallback<? super WorkbookChartPoint> callback) {
        send(HttpMethod.PATCH, callback, srcWorkbookChartPoint);
    }

    /**
     * Patches the WorkbookChartPointItemAt
     *
     * @param srcWorkbookChartPoint the WorkbookChartPoint with which to PATCH
     * @return the WorkbookChartPoint
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
     public WorkbookChartPoint patch(WorkbookChartPoint srcWorkbookChartPoint) throws ClientException {
        return this.send(HttpMethod.PATCH, srcWorkbookChartPoint);
    }

    /**
     * Puts the WorkbookChartPointItemAt
     *
     * @param srcWorkbookChartPoint the WorkbookChartPoint to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(WorkbookChartPoint srcWorkbookChartPoint, final ICallback<? super WorkbookChartPoint> callback) {
        send(HttpMethod.PUT, callback, srcWorkbookChartPoint);
    }

    /**
     * Puts the WorkbookChartPointItemAt
     *
     * @param srcWorkbookChartPoint the WorkbookChartPoint to PUT
     * @return the WorkbookChartPoint
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
     public WorkbookChartPoint put(WorkbookChartPoint srcWorkbookChartPoint) throws ClientException {
        return this.send(HttpMethod.PUT, srcWorkbookChartPoint);
    }
    /**
     * Gets the WorkbookChartPoint
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super WorkbookChartPoint> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookChartPoint
     *
     * @return the WorkbookChartPoint
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public WorkbookChartPoint get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IWorkbookChartPointItemAtRequest select(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
        return (WorkbookChartPointItemAtRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IWorkbookChartPointItemAtRequest expand(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (WorkbookChartPointItemAtRequest)this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    public IWorkbookChartPointItemAtRequest filter(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$filter", value));
        return (WorkbookChartPointItemAtRequest)this;
    }

    /**
     * Sets the order by clause for the request
     *
     * @param value the order by clause
     * @return the updated request
     */
    public IWorkbookChartPointItemAtRequest orderBy(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$orderby", value));
        return (WorkbookChartPointItemAtRequest)this;
    }

}
