// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.WindowsInformationProtection;
import com.microsoft.graph.models.extensions.TargetedManagedAppPolicyAssignment;
import com.microsoft.graph.requests.extensions.ITargetedManagedAppPolicyAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ITargetedManagedAppPolicyAssignmentRequestBuilder;
import com.microsoft.graph.requests.extensions.TargetedManagedAppPolicyAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TargetedManagedAppPolicyAssignmentRequestBuilder;
import com.microsoft.graph.requests.extensions.IWindowsInformationProtectionAppLockerFileCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IWindowsInformationProtectionAppLockerFileRequestBuilder;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionAppLockerFileCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionAppLockerFileRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Information Protection Request.
 */
public class WindowsInformationProtectionRequest extends BaseRequest implements IWindowsInformationProtectionRequest {
	
    /**
     * The request for the WindowsInformationProtection
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public WindowsInformationProtectionRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            final Class<? extends WindowsInformationProtection> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the WindowsInformationProtection
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WindowsInformationProtectionRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsInformationProtection.class);
    }

    /**
     * Gets the WindowsInformationProtection from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super WindowsInformationProtection> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WindowsInformationProtection from the service
     *
     * @return the WindowsInformationProtection from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WindowsInformationProtection get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super WindowsInformationProtection> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WindowsInformationProtection with a source
     *
     * @param sourceWindowsInformationProtection the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final WindowsInformationProtection sourceWindowsInformationProtection, final ICallback<? super WindowsInformationProtection> callback) {
        send(HttpMethod.PATCH, callback, sourceWindowsInformationProtection);
    }

    /**
     * Patches this WindowsInformationProtection with a source
     *
     * @param sourceWindowsInformationProtection the source object with updates
     * @return the updated WindowsInformationProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WindowsInformationProtection patch(final WindowsInformationProtection sourceWindowsInformationProtection) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindowsInformationProtection);
    }

    /**
     * Creates a WindowsInformationProtection with a new object
     *
     * @param newWindowsInformationProtection the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final WindowsInformationProtection newWindowsInformationProtection, final ICallback<? super WindowsInformationProtection> callback) {
        send(HttpMethod.POST, callback, newWindowsInformationProtection);
    }

    /**
     * Creates a WindowsInformationProtection with a new object
     *
     * @param newWindowsInformationProtection the new object to create
     * @return the created WindowsInformationProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WindowsInformationProtection post(final WindowsInformationProtection newWindowsInformationProtection) throws ClientException {
        return send(HttpMethod.POST, newWindowsInformationProtection);
    }

    /**
     * Creates a WindowsInformationProtection with a new object
     *
     * @param newWindowsInformationProtection the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final WindowsInformationProtection newWindowsInformationProtection, final ICallback<? super WindowsInformationProtection> callback) {
        send(HttpMethod.PUT, callback, newWindowsInformationProtection);
    }

    /**
     * Creates a WindowsInformationProtection with a new object
     *
     * @param newWindowsInformationProtection the object to create/update
     * @return the created WindowsInformationProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WindowsInformationProtection put(final WindowsInformationProtection newWindowsInformationProtection) throws ClientException {
        return send(HttpMethod.PUT, newWindowsInformationProtection);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IWindowsInformationProtectionRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (WindowsInformationProtectionRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IWindowsInformationProtectionRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (WindowsInformationProtectionRequest)this;
     }

}

