// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IUserRemoveAllDevicesFromManagementRequest;
import com.microsoft.graph.requests.extensions.UserRemoveAllDevicesFromManagementRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Remove All Devices From Management Request Builder.
 */
public class UserRemoveAllDevicesFromManagementRequestBuilder extends BaseActionRequestBuilder implements IUserRemoveAllDevicesFromManagementRequestBuilder {

    /**
     * The request builder for this UserRemoveAllDevicesFromManagement
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserRemoveAllDevicesFromManagementRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IUserRemoveAllDevicesFromManagementRequest
     *
     * @param requestOptions the options for the request
     * @return the IUserRemoveAllDevicesFromManagementRequest instance
     */
    public IUserRemoveAllDevicesFromManagementRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IUserRemoveAllDevicesFromManagementRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IUserRemoveAllDevicesFromManagementRequest instance
     */
    public IUserRemoveAllDevicesFromManagementRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        UserRemoveAllDevicesFromManagementRequest request = new UserRemoveAllDevicesFromManagementRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
