// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.SharedPCConfiguration;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Shared PCConfiguration Request.
 */
public interface ISharedPCConfigurationRequest extends IHttpRequest {

    /**
     * Gets the SharedPCConfiguration from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super SharedPCConfiguration> callback);

    /**
     * Gets the SharedPCConfiguration from the service
     *
     * @return the SharedPCConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SharedPCConfiguration get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super SharedPCConfiguration> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this SharedPCConfiguration with a source
     *
     * @param sourceSharedPCConfiguration the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final SharedPCConfiguration sourceSharedPCConfiguration, final ICallback<? super SharedPCConfiguration> callback);

    /**
     * Patches this SharedPCConfiguration with a source
     *
     * @param sourceSharedPCConfiguration the source object with updates
     * @return the updated SharedPCConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SharedPCConfiguration patch(final SharedPCConfiguration sourceSharedPCConfiguration) throws ClientException;

    /**
     * Posts a SharedPCConfiguration with a new object
     *
     * @param newSharedPCConfiguration the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final SharedPCConfiguration newSharedPCConfiguration, final ICallback<? super SharedPCConfiguration> callback);

    /**
     * Posts a SharedPCConfiguration with a new object
     *
     * @param newSharedPCConfiguration the new object to create
     * @return the created SharedPCConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SharedPCConfiguration post(final SharedPCConfiguration newSharedPCConfiguration) throws ClientException;

    /**
     * Posts a SharedPCConfiguration with a new object
     *
     * @param newSharedPCConfiguration the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final SharedPCConfiguration newSharedPCConfiguration, final ICallback<? super SharedPCConfiguration> callback);

    /**
     * Posts a SharedPCConfiguration with a new object
     *
     * @param newSharedPCConfiguration the object to create/update
     * @return the created SharedPCConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SharedPCConfiguration put(final SharedPCConfiguration newSharedPCConfiguration) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ISharedPCConfigurationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ISharedPCConfigurationRequest expand(final String value);

}

