// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Planner;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Planner Request.
 */
public interface IPlannerRequest extends IHttpRequest {

    /**
     * Gets the Planner from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super Planner> callback);

    /**
     * Gets the Planner from the service
     *
     * @return the Planner from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Planner get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super Planner> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Planner with a source
     *
     * @param sourcePlanner the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Planner sourcePlanner, final ICallback<? super Planner> callback);

    /**
     * Patches this Planner with a source
     *
     * @param sourcePlanner the source object with updates
     * @return the updated Planner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Planner patch(final Planner sourcePlanner) throws ClientException;

    /**
     * Posts a Planner with a new object
     *
     * @param newPlanner the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Planner newPlanner, final ICallback<? super Planner> callback);

    /**
     * Posts a Planner with a new object
     *
     * @param newPlanner the new object to create
     * @return the created Planner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Planner post(final Planner newPlanner) throws ClientException;

    /**
     * Posts a Planner with a new object
     *
     * @param newPlanner the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final Planner newPlanner, final ICallback<? super Planner> callback);

    /**
     * Posts a Planner with a new object
     *
     * @param newPlanner the object to create/update
     * @return the created Planner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Planner put(final Planner newPlanner) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IPlannerRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IPlannerRequest expand(final String value);

}

