// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.MailAssessmentRequest;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Mail Assessment Request Request.
 */
public interface IMailAssessmentRequestRequest extends IHttpRequest {

    /**
     * Gets the MailAssessmentRequest from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super MailAssessmentRequest> callback);

    /**
     * Gets the MailAssessmentRequest from the service
     *
     * @return the MailAssessmentRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MailAssessmentRequest get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super MailAssessmentRequest> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this MailAssessmentRequest with a source
     *
     * @param sourceMailAssessmentRequest the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final MailAssessmentRequest sourceMailAssessmentRequest, final ICallback<? super MailAssessmentRequest> callback);

    /**
     * Patches this MailAssessmentRequest with a source
     *
     * @param sourceMailAssessmentRequest the source object with updates
     * @return the updated MailAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MailAssessmentRequest patch(final MailAssessmentRequest sourceMailAssessmentRequest) throws ClientException;

    /**
     * Posts a MailAssessmentRequest with a new object
     *
     * @param newMailAssessmentRequest the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final MailAssessmentRequest newMailAssessmentRequest, final ICallback<? super MailAssessmentRequest> callback);

    /**
     * Posts a MailAssessmentRequest with a new object
     *
     * @param newMailAssessmentRequest the new object to create
     * @return the created MailAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MailAssessmentRequest post(final MailAssessmentRequest newMailAssessmentRequest) throws ClientException;

    /**
     * Posts a MailAssessmentRequest with a new object
     *
     * @param newMailAssessmentRequest the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final MailAssessmentRequest newMailAssessmentRequest, final ICallback<? super MailAssessmentRequest> callback);

    /**
     * Posts a MailAssessmentRequest with a new object
     *
     * @param newMailAssessmentRequest the object to create/update
     * @return the created MailAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MailAssessmentRequest put(final MailAssessmentRequest newMailAssessmentRequest) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IMailAssessmentRequestRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IMailAssessmentRequestRequest expand(final String value);

}

