// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.ExtensionProperty;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.IDirectoryObjectGetAvailableExtensionPropertiesCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDirectoryObjectGetAvailableExtensionPropertiesCollectionRequest;
import com.microsoft.graph.requests.extensions.DirectoryObjectGetAvailableExtensionPropertiesCollectionRequest;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.core.BaseActionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Directory Object Get Available Extension Properties Collection Request Builder.
 */
public class DirectoryObjectGetAvailableExtensionPropertiesCollectionRequestBuilder extends BaseActionRequestBuilder implements IDirectoryObjectGetAvailableExtensionPropertiesCollectionRequestBuilder {

    /**
     * The request builder for this collection of DirectoryObject
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param isSyncedFromOnPremises the isSyncedFromOnPremises
     */
    public DirectoryObjectGetAvailableExtensionPropertiesCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final Boolean isSyncedFromOnPremises) {
        super(requestUrl, client, requestOptions);
  	 if(isSyncedFromOnPremises!=null){
			bodyParams.put("isSyncedFromOnPremises", isSyncedFromOnPremises);
		}
      }
    
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IUserRequest instance
     */
    public IDirectoryObjectGetAvailableExtensionPropertiesCollectionRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IUserRequest instance
     */
    public IDirectoryObjectGetAvailableExtensionPropertiesCollectionRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        DirectoryObjectGetAvailableExtensionPropertiesCollectionRequest request = new DirectoryObjectGetAvailableExtensionPropertiesCollectionRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("isSyncedFromOnPremises")) {
            request.body.isSyncedFromOnPremises = getParameter("isSyncedFromOnPremises");
        }
  
        return request;
    }
}
