// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.AndroidGeneralDeviceConfiguration;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Android General Device Configuration Request.
 */
public class AndroidGeneralDeviceConfigurationRequest extends BaseRequest implements IAndroidGeneralDeviceConfigurationRequest {
	
    /**
     * The request for the AndroidGeneralDeviceConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AndroidGeneralDeviceConfigurationRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AndroidGeneralDeviceConfiguration.class);
    }

    /**
     * Gets the AndroidGeneralDeviceConfiguration from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super AndroidGeneralDeviceConfiguration> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the AndroidGeneralDeviceConfiguration from the service
     *
     * @return the AndroidGeneralDeviceConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AndroidGeneralDeviceConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super AndroidGeneralDeviceConfiguration> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AndroidGeneralDeviceConfiguration with a source
     *
     * @param sourceAndroidGeneralDeviceConfiguration the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final AndroidGeneralDeviceConfiguration sourceAndroidGeneralDeviceConfiguration, final ICallback<? super AndroidGeneralDeviceConfiguration> callback) {
        send(HttpMethod.PATCH, callback, sourceAndroidGeneralDeviceConfiguration);
    }

    /**
     * Patches this AndroidGeneralDeviceConfiguration with a source
     *
     * @param sourceAndroidGeneralDeviceConfiguration the source object with updates
     * @return the updated AndroidGeneralDeviceConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AndroidGeneralDeviceConfiguration patch(final AndroidGeneralDeviceConfiguration sourceAndroidGeneralDeviceConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceAndroidGeneralDeviceConfiguration);
    }

    /**
     * Creates a AndroidGeneralDeviceConfiguration with a new object
     *
     * @param newAndroidGeneralDeviceConfiguration the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final AndroidGeneralDeviceConfiguration newAndroidGeneralDeviceConfiguration, final ICallback<? super AndroidGeneralDeviceConfiguration> callback) {
        send(HttpMethod.POST, callback, newAndroidGeneralDeviceConfiguration);
    }

    /**
     * Creates a AndroidGeneralDeviceConfiguration with a new object
     *
     * @param newAndroidGeneralDeviceConfiguration the new object to create
     * @return the created AndroidGeneralDeviceConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AndroidGeneralDeviceConfiguration post(final AndroidGeneralDeviceConfiguration newAndroidGeneralDeviceConfiguration) throws ClientException {
        return send(HttpMethod.POST, newAndroidGeneralDeviceConfiguration);
    }

    /**
     * Creates a AndroidGeneralDeviceConfiguration with a new object
     *
     * @param newAndroidGeneralDeviceConfiguration the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final AndroidGeneralDeviceConfiguration newAndroidGeneralDeviceConfiguration, final ICallback<? super AndroidGeneralDeviceConfiguration> callback) {
        send(HttpMethod.PUT, callback, newAndroidGeneralDeviceConfiguration);
    }

    /**
     * Creates a AndroidGeneralDeviceConfiguration with a new object
     *
     * @param newAndroidGeneralDeviceConfiguration the object to create/update
     * @return the created AndroidGeneralDeviceConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AndroidGeneralDeviceConfiguration put(final AndroidGeneralDeviceConfiguration newAndroidGeneralDeviceConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newAndroidGeneralDeviceConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IAndroidGeneralDeviceConfigurationRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (AndroidGeneralDeviceConfigurationRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IAndroidGeneralDeviceConfigurationRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (AndroidGeneralDeviceConfigurationRequest)this;
     }

}

