/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITodoTaskDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.ITodoTaskDeltaCollectionRequest;
import com.microsoft.graph.requests.extensions.TodoTaskDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.TodoTaskDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TodoTaskDeltaCollectionResponse;
import java.util.List;

public class TodoTaskDeltaCollectionRequest
extends BaseCollectionRequest<TodoTaskDeltaCollectionResponse, ITodoTaskDeltaCollectionPage>
implements ITodoTaskDeltaCollectionRequest {
    public TodoTaskDeltaCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TodoTaskDeltaCollectionResponse.class, ITodoTaskDeltaCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ITodoTaskDeltaCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TodoTaskDeltaCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITodoTaskDeltaCollectionPage get() throws ClientException {
        TodoTaskDeltaCollectionResponse response = (TodoTaskDeltaCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public ITodoTaskDeltaCollectionPage buildFromResponse(TodoTaskDeltaCollectionResponse response) {
        TodoTaskDeltaCollectionRequestBuilder builder = response.nextLink != null ? new TodoTaskDeltaCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TodoTaskDeltaCollectionPage page = new TodoTaskDeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public ITodoTaskDeltaCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITodoTaskDeltaCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ITodoTaskDeltaCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public ITodoTaskDeltaCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public ITodoTaskDeltaCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

