/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.TeamsTemplate;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITeamsTemplateWithReferenceRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;

public class TeamsTemplateWithReferenceRequest
extends BaseRequest
implements ITeamsTemplateWithReferenceRequest {
    public TeamsTemplateWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamsTemplate.class);
    }

    @Override
    public void post(TeamsTemplate newTeamsTemplate, IJsonBackedObject payload, ICallback<? super TeamsTemplate> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public TeamsTemplate post(TeamsTemplate newTeamsTemplate, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newTeamsTemplate;
        }
        return null;
    }

    @Override
    public void get(ICallback<? super TeamsTemplate> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public TeamsTemplate get() throws ClientException {
        return (TeamsTemplate)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super TeamsTemplate> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(TeamsTemplate sourceTeamsTemplate, ICallback<? super TeamsTemplate> callback) {
        this.send(HttpMethod.PATCH, callback, sourceTeamsTemplate);
    }

    @Override
    public TeamsTemplate patch(TeamsTemplate sourceTeamsTemplate) throws ClientException {
        return (TeamsTemplate)this.send(HttpMethod.PATCH, sourceTeamsTemplate);
    }

    @Override
    public ITeamsTemplateWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITeamsTemplateWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

