/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ApplicationCollectionResponse;
import com.microsoft.graph.requests.extensions.ApplicationCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.ApplicationCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IApplicationCollectionPage;
import com.microsoft.graph.requests.extensions.IApplicationCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IApplicationCollectionWithReferencesRequest;
import java.util.List;

public class ApplicationCollectionWithReferencesRequest
extends BaseCollectionRequest<ApplicationCollectionResponse, IApplicationCollectionPage>
implements IApplicationCollectionWithReferencesRequest {
    public ApplicationCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ApplicationCollectionResponse.class, IApplicationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IApplicationCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ApplicationCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IApplicationCollectionWithReferencesPage get() throws ClientException {
        ApplicationCollectionResponse response = (ApplicationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IApplicationCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IApplicationCollectionWithReferencesRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IApplicationCollectionWithReferencesRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IApplicationCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IApplicationCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IApplicationCollectionWithReferencesPage buildFromResponse(ApplicationCollectionResponse response) {
        ApplicationCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new ApplicationCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ApplicationCollectionWithReferencesPage page = new ApplicationCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

