/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IServicePrincipalDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.IServicePrincipalDeltaCollectionRequest;
import com.microsoft.graph.requests.extensions.ServicePrincipalDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.ServicePrincipalDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ServicePrincipalDeltaCollectionResponse;
import java.util.List;

public class ServicePrincipalDeltaCollectionRequest
extends BaseCollectionRequest<ServicePrincipalDeltaCollectionResponse, IServicePrincipalDeltaCollectionPage>
implements IServicePrincipalDeltaCollectionRequest {
    public ServicePrincipalDeltaCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ServicePrincipalDeltaCollectionResponse.class, IServicePrincipalDeltaCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IServicePrincipalDeltaCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ServicePrincipalDeltaCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IServicePrincipalDeltaCollectionPage get() throws ClientException {
        ServicePrincipalDeltaCollectionResponse response = (ServicePrincipalDeltaCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IServicePrincipalDeltaCollectionPage buildFromResponse(ServicePrincipalDeltaCollectionResponse response) {
        ServicePrincipalDeltaCollectionRequestBuilder builder = response.nextLink != null ? new ServicePrincipalDeltaCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ServicePrincipalDeltaCollectionPage page = new ServicePrincipalDeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IServicePrincipalDeltaCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IServicePrincipalDeltaCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IServicePrincipalDeltaCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IServicePrincipalDeltaCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IServicePrincipalDeltaCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

