/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.MobileApp;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMobileAppCollectionPage;
import com.microsoft.graph.requests.extensions.IMobileAppCollectionRequest;
import com.microsoft.graph.requests.extensions.MobileAppCollectionPage;
import com.microsoft.graph.requests.extensions.MobileAppCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MobileAppCollectionResponse;
import com.microsoft.graph.requests.extensions.MobileAppRequestBuilder;
import java.util.List;

public class MobileAppCollectionRequest
extends BaseCollectionRequest<MobileAppCollectionResponse, IMobileAppCollectionPage>
implements IMobileAppCollectionRequest {
    public MobileAppCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileAppCollectionResponse.class, IMobileAppCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IMobileAppCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(MobileAppCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMobileAppCollectionPage get() throws ClientException {
        MobileAppCollectionResponse response = (MobileAppCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(MobileApp newMobileApp, ICallback<? super MobileApp> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MobileAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newMobileApp, callback);
    }

    @Override
    public MobileApp post(MobileApp newMobileApp) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MobileAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newMobileApp);
    }

    @Override
    public IMobileAppCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IMobileAppCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IMobileAppCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IMobileAppCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IMobileAppCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IMobileAppCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IMobileAppCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IMobileAppCollectionPage buildFromResponse(MobileAppCollectionResponse response) {
        MobileAppCollectionRequestBuilder builder = response.nextLink != null ? new MobileAppCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MobileAppCollectionPage page = new MobileAppCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

