/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Printer;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrinterWithReferenceRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;

public class PrinterWithReferenceRequest
extends BaseRequest
implements IPrinterWithReferenceRequest {
    public PrinterWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Printer.class);
    }

    @Override
    public void post(Printer newPrinter, IJsonBackedObject payload, ICallback<? super Printer> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public Printer post(Printer newPrinter, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newPrinter;
        }
        return null;
    }

    @Override
    public void get(ICallback<? super Printer> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Printer get() throws ClientException {
        return (Printer)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Printer> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Printer sourcePrinter, ICallback<? super Printer> callback) {
        this.send(HttpMethod.PATCH, callback, sourcePrinter);
    }

    @Override
    public Printer patch(Printer sourcePrinter) throws ClientException {
        return (Printer)this.send(HttpMethod.PATCH, sourcePrinter);
    }

    @Override
    public IPrinterWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrinterWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

