/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.PrintUsageByPrinter;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrintUsageByPrinterCollectionPage;
import com.microsoft.graph.requests.extensions.IPrintUsageByPrinterCollectionRequest;
import com.microsoft.graph.requests.extensions.PrintUsageByPrinterCollectionPage;
import com.microsoft.graph.requests.extensions.PrintUsageByPrinterCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintUsageByPrinterCollectionResponse;
import com.microsoft.graph.requests.extensions.PrintUsageByPrinterRequestBuilder;
import java.util.List;

public class PrintUsageByPrinterCollectionRequest
extends BaseCollectionRequest<PrintUsageByPrinterCollectionResponse, IPrintUsageByPrinterCollectionPage>
implements IPrintUsageByPrinterCollectionRequest {
    public PrintUsageByPrinterCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintUsageByPrinterCollectionResponse.class, IPrintUsageByPrinterCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IPrintUsageByPrinterCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PrintUsageByPrinterCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPrintUsageByPrinterCollectionPage get() throws ClientException {
        PrintUsageByPrinterCollectionResponse response = (PrintUsageByPrinterCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PrintUsageByPrinter newPrintUsageByPrinter, ICallback<? super PrintUsageByPrinter> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PrintUsageByPrinterRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintUsageByPrinter, callback);
    }

    @Override
    public PrintUsageByPrinter post(PrintUsageByPrinter newPrintUsageByPrinter) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PrintUsageByPrinterRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintUsageByPrinter);
    }

    @Override
    public IPrintUsageByPrinterCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPrintUsageByPrinterCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IPrintUsageByPrinterCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IPrintUsageByPrinterCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrintUsageByPrinterCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPrintUsageByPrinterCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPrintUsageByPrinterCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPrintUsageByPrinterCollectionPage buildFromResponse(PrintUsageByPrinterCollectionResponse response) {
        PrintUsageByPrinterCollectionRequestBuilder builder = response.nextLink != null ? new PrintUsageByPrinterCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PrintUsageByPrinterCollectionPage page = new PrintUsageByPrinterCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

