/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Notebook;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.INotebookCollectionPage;
import com.microsoft.graph.requests.extensions.INotebookCollectionRequest;
import com.microsoft.graph.requests.extensions.NotebookCollectionPage;
import com.microsoft.graph.requests.extensions.NotebookCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.NotebookCollectionResponse;
import com.microsoft.graph.requests.extensions.NotebookRequestBuilder;
import java.util.List;

public class NotebookCollectionRequest
extends BaseCollectionRequest<NotebookCollectionResponse, INotebookCollectionPage>
implements INotebookCollectionRequest {
    public NotebookCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, NotebookCollectionResponse.class, INotebookCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super INotebookCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(NotebookCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public INotebookCollectionPage get() throws ClientException {
        NotebookCollectionResponse response = (NotebookCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Notebook newNotebook, ICallback<? super Notebook> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new NotebookRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newNotebook, callback);
    }

    @Override
    public Notebook post(Notebook newNotebook) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new NotebookRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newNotebook);
    }

    @Override
    public INotebookCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public INotebookCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public INotebookCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public INotebookCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public INotebookCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public INotebookCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public INotebookCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public INotebookCollectionPage buildFromResponse(NotebookCollectionResponse response) {
        NotebookCollectionRequestBuilder builder = response.nextLink != null ? new NotebookCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        NotebookCollectionPage page = new NotebookCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

