// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.PrintTask;
import com.microsoft.graph.requests.extensions.IPrintTaskDefinitionWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintTaskDefinitionWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintTaskTriggerWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintTaskTriggerWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Task Request.
 */
public class PrintTaskRequest extends BaseRequest implements IPrintTaskRequest {
	
    /**
     * The request for the PrintTask
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintTaskRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintTask.class);
    }

    /**
     * Gets the PrintTask from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super PrintTask> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the PrintTask from the service
     *
     * @return the PrintTask from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintTask get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super PrintTask> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrintTask with a source
     *
     * @param sourcePrintTask the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final PrintTask sourcePrintTask, final ICallback<? super PrintTask> callback) {
        send(HttpMethod.PATCH, callback, sourcePrintTask);
    }

    /**
     * Patches this PrintTask with a source
     *
     * @param sourcePrintTask the source object with updates
     * @return the updated PrintTask
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintTask patch(final PrintTask sourcePrintTask) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrintTask);
    }

    /**
     * Creates a PrintTask with a new object
     *
     * @param newPrintTask the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final PrintTask newPrintTask, final ICallback<? super PrintTask> callback) {
        send(HttpMethod.POST, callback, newPrintTask);
    }

    /**
     * Creates a PrintTask with a new object
     *
     * @param newPrintTask the new object to create
     * @return the created PrintTask
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintTask post(final PrintTask newPrintTask) throws ClientException {
        return send(HttpMethod.POST, newPrintTask);
    }

    /**
     * Creates a PrintTask with a new object
     *
     * @param newPrintTask the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final PrintTask newPrintTask, final ICallback<? super PrintTask> callback) {
        send(HttpMethod.PUT, callback, newPrintTask);
    }

    /**
     * Creates a PrintTask with a new object
     *
     * @param newPrintTask the object to create/update
     * @return the created PrintTask
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintTask put(final PrintTask newPrintTask) throws ClientException {
        return send(HttpMethod.PUT, newPrintTask);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IPrintTaskRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (PrintTaskRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IPrintTaskRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (PrintTaskRequest)this;
     }

}

