// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.PrintJob;
import com.microsoft.graph.models.extensions.PrintJobConfiguration;
import com.microsoft.graph.models.extensions.PrintJobStatus;
import com.microsoft.graph.requests.extensions.IPrintDocumentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintDocumentRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintDocumentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintDocumentRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintTaskCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintTaskRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintTaskCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintTaskRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Job Request Builder.
 */
public class PrintJobRequestBuilder extends BaseRequestBuilder implements IPrintJobRequestBuilder {

    /**
     * The request builder for the PrintJob
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintJobRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IPrintJobRequest instance
     */
    public IPrintJobRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IPrintJobRequest instance
     */
    public IPrintJobRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.extensions.PrintJobRequest(getRequestUrl(), getClient(), requestOptions);
    }


    public IPrintDocumentCollectionRequestBuilder documents() {
        return new PrintDocumentCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("documents"), getClient(), null);
    }

    public IPrintDocumentRequestBuilder documents(final String id) {
        return new PrintDocumentRequestBuilder(getRequestUrlWithAdditionalSegment("documents") + "/" + id, getClient(), null);
    }
    public IPrintTaskCollectionRequestBuilder tasks() {
        return new PrintTaskCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("tasks"), getClient(), null);
    }

    public IPrintTaskRequestBuilder tasks(final String id) {
        return new PrintTaskRequestBuilder(getRequestUrlWithAdditionalSegment("tasks") + "/" + id, getClient(), null);
    }

    public IPrintJobCancelRequestBuilder cancel() {
        return new PrintJobCancelRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.cancel"), getClient(), null);
    }

    public IPrintJobAbortRequestBuilder abort(final String reason) {
        return new PrintJobAbortRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.abort"), getClient(), null, reason);
    }

    public IPrintJobRedirectRequestBuilder redirect(final String destinationPrinterId, final PrintJobConfiguration configuration) {
        return new PrintJobRedirectRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.redirect"), getClient(), null, destinationPrinterId, configuration);
    }

    public IPrintJobStartRequestBuilder start() {
        return new PrintJobStartRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.start"), getClient(), null);
    }
}
