// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.PrintDocument;
import com.microsoft.graph.models.extensions.PrintDocumentUploadProperties;
import com.microsoft.graph.models.extensions.UploadSession;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Document Request Builder.
 */
public class PrintDocumentRequestBuilder extends BaseRequestBuilder implements IPrintDocumentRequestBuilder {

    /**
     * The request builder for the PrintDocument
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintDocumentRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IPrintDocumentRequest instance
     */
    public IPrintDocumentRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IPrintDocumentRequest instance
     */
    public IPrintDocumentRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.extensions.PrintDocumentRequest(getRequestUrl(), getClient(), requestOptions);
    }



    public IPrintDocumentStreamRequestBuilder content() {
        return new PrintDocumentStreamRequestBuilder(getRequestUrlWithAdditionalSegment("$value"), getClient(), null);
    }

    public IPrintDocumentCreateUploadSessionRequestBuilder createUploadSession(final PrintDocumentUploadProperties properties) {
        return new PrintDocumentCreateUploadSessionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.createUploadSession"), getClient(), null, properties);
    }
}
