// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.PrintDocument;
import com.microsoft.graph.models.extensions.PrintDocumentUploadProperties;
import com.microsoft.graph.models.extensions.UploadSession;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Document Request.
 */
public class PrintDocumentRequest extends BaseRequest implements IPrintDocumentRequest {
	
    /**
     * The request for the PrintDocument
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintDocumentRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintDocument.class);
    }

    /**
     * Gets the PrintDocument from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super PrintDocument> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the PrintDocument from the service
     *
     * @return the PrintDocument from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintDocument get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super PrintDocument> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrintDocument with a source
     *
     * @param sourcePrintDocument the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final PrintDocument sourcePrintDocument, final ICallback<? super PrintDocument> callback) {
        send(HttpMethod.PATCH, callback, sourcePrintDocument);
    }

    /**
     * Patches this PrintDocument with a source
     *
     * @param sourcePrintDocument the source object with updates
     * @return the updated PrintDocument
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintDocument patch(final PrintDocument sourcePrintDocument) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrintDocument);
    }

    /**
     * Creates a PrintDocument with a new object
     *
     * @param newPrintDocument the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final PrintDocument newPrintDocument, final ICallback<? super PrintDocument> callback) {
        send(HttpMethod.POST, callback, newPrintDocument);
    }

    /**
     * Creates a PrintDocument with a new object
     *
     * @param newPrintDocument the new object to create
     * @return the created PrintDocument
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintDocument post(final PrintDocument newPrintDocument) throws ClientException {
        return send(HttpMethod.POST, newPrintDocument);
    }

    /**
     * Creates a PrintDocument with a new object
     *
     * @param newPrintDocument the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final PrintDocument newPrintDocument, final ICallback<? super PrintDocument> callback) {
        send(HttpMethod.PUT, callback, newPrintDocument);
    }

    /**
     * Creates a PrintDocument with a new object
     *
     * @param newPrintDocument the object to create/update
     * @return the created PrintDocument
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintDocument put(final PrintDocument newPrintDocument) throws ClientException {
        return send(HttpMethod.PUT, newPrintDocument);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IPrintDocumentRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (PrintDocumentRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IPrintDocumentRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (PrintDocumentRequest)this;
     }

}

