// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.PolicyRoot;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Policy Root Request.
 */
public interface IPolicyRootRequest extends IHttpRequest {

    /**
     * Gets the PolicyRoot from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super PolicyRoot> callback);

    /**
     * Gets the PolicyRoot from the service
     *
     * @return the PolicyRoot from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PolicyRoot get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super PolicyRoot> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this PolicyRoot with a source
     *
     * @param sourcePolicyRoot the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final PolicyRoot sourcePolicyRoot, final ICallback<? super PolicyRoot> callback);

    /**
     * Patches this PolicyRoot with a source
     *
     * @param sourcePolicyRoot the source object with updates
     * @return the updated PolicyRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PolicyRoot patch(final PolicyRoot sourcePolicyRoot) throws ClientException;

    /**
     * Posts a PolicyRoot with a new object
     *
     * @param newPolicyRoot the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final PolicyRoot newPolicyRoot, final ICallback<? super PolicyRoot> callback);

    /**
     * Posts a PolicyRoot with a new object
     *
     * @param newPolicyRoot the new object to create
     * @return the created PolicyRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PolicyRoot post(final PolicyRoot newPolicyRoot) throws ClientException;

    /**
     * Posts a PolicyRoot with a new object
     *
     * @param newPolicyRoot the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final PolicyRoot newPolicyRoot, final ICallback<? super PolicyRoot> callback);

    /**
     * Posts a PolicyRoot with a new object
     *
     * @param newPolicyRoot the object to create/update
     * @return the created PolicyRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PolicyRoot put(final PolicyRoot newPolicyRoot) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IPolicyRootRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IPolicyRootRequest expand(final String value);

}

