// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.IdentityGovernance;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Identity Governance Request.
 */
public interface IIdentityGovernanceRequest extends IHttpRequest {

    /**
     * Gets the IdentityGovernance from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super IdentityGovernance> callback);

    /**
     * Gets the IdentityGovernance from the service
     *
     * @return the IdentityGovernance from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IdentityGovernance get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super IdentityGovernance> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this IdentityGovernance with a source
     *
     * @param sourceIdentityGovernance the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final IdentityGovernance sourceIdentityGovernance, final ICallback<? super IdentityGovernance> callback);

    /**
     * Patches this IdentityGovernance with a source
     *
     * @param sourceIdentityGovernance the source object with updates
     * @return the updated IdentityGovernance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IdentityGovernance patch(final IdentityGovernance sourceIdentityGovernance) throws ClientException;

    /**
     * Posts a IdentityGovernance with a new object
     *
     * @param newIdentityGovernance the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final IdentityGovernance newIdentityGovernance, final ICallback<? super IdentityGovernance> callback);

    /**
     * Posts a IdentityGovernance with a new object
     *
     * @param newIdentityGovernance the new object to create
     * @return the created IdentityGovernance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IdentityGovernance post(final IdentityGovernance newIdentityGovernance) throws ClientException;

    /**
     * Posts a IdentityGovernance with a new object
     *
     * @param newIdentityGovernance the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final IdentityGovernance newIdentityGovernance, final ICallback<? super IdentityGovernance> callback);

    /**
     * Posts a IdentityGovernance with a new object
     *
     * @param newIdentityGovernance the object to create/update
     * @return the created IdentityGovernance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IdentityGovernance put(final IdentityGovernance newIdentityGovernance) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IIdentityGovernanceRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IIdentityGovernanceRequest expand(final String value);

}

