// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Authentication;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Authentication Request.
 */
public interface IAuthenticationRequest extends IHttpRequest {

    /**
     * Gets the Authentication from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super Authentication> callback);

    /**
     * Gets the Authentication from the service
     *
     * @return the Authentication from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Authentication get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super Authentication> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Authentication with a source
     *
     * @param sourceAuthentication the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Authentication sourceAuthentication, final ICallback<? super Authentication> callback);

    /**
     * Patches this Authentication with a source
     *
     * @param sourceAuthentication the source object with updates
     * @return the updated Authentication
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Authentication patch(final Authentication sourceAuthentication) throws ClientException;

    /**
     * Posts a Authentication with a new object
     *
     * @param newAuthentication the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Authentication newAuthentication, final ICallback<? super Authentication> callback);

    /**
     * Posts a Authentication with a new object
     *
     * @param newAuthentication the new object to create
     * @return the created Authentication
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Authentication post(final Authentication newAuthentication) throws ClientException;

    /**
     * Posts a Authentication with a new object
     *
     * @param newAuthentication the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final Authentication newAuthentication, final ICallback<? super Authentication> callback);

    /**
     * Posts a Authentication with a new object
     *
     * @param newAuthentication the object to create/update
     * @return the created Authentication
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Authentication put(final Authentication newAuthentication) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IAuthenticationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IAuthenticationRequest expand(final String value);

}

