// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.AgreementFile;
import com.microsoft.graph.requests.extensions.IAgreementFileLocalizationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IAgreementFileLocalizationRequestBuilder;
import com.microsoft.graph.requests.extensions.AgreementFileLocalizationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AgreementFileLocalizationRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Agreement File Request.
 */
public class AgreementFileRequest extends BaseRequest implements IAgreementFileRequest {
	
    /**
     * The request for the AgreementFile
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AgreementFileRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AgreementFile.class);
    }

    /**
     * Gets the AgreementFile from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super AgreementFile> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the AgreementFile from the service
     *
     * @return the AgreementFile from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AgreementFile get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super AgreementFile> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AgreementFile with a source
     *
     * @param sourceAgreementFile the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final AgreementFile sourceAgreementFile, final ICallback<? super AgreementFile> callback) {
        send(HttpMethod.PATCH, callback, sourceAgreementFile);
    }

    /**
     * Patches this AgreementFile with a source
     *
     * @param sourceAgreementFile the source object with updates
     * @return the updated AgreementFile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AgreementFile patch(final AgreementFile sourceAgreementFile) throws ClientException {
        return send(HttpMethod.PATCH, sourceAgreementFile);
    }

    /**
     * Creates a AgreementFile with a new object
     *
     * @param newAgreementFile the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final AgreementFile newAgreementFile, final ICallback<? super AgreementFile> callback) {
        send(HttpMethod.POST, callback, newAgreementFile);
    }

    /**
     * Creates a AgreementFile with a new object
     *
     * @param newAgreementFile the new object to create
     * @return the created AgreementFile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AgreementFile post(final AgreementFile newAgreementFile) throws ClientException {
        return send(HttpMethod.POST, newAgreementFile);
    }

    /**
     * Creates a AgreementFile with a new object
     *
     * @param newAgreementFile the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final AgreementFile newAgreementFile, final ICallback<? super AgreementFile> callback) {
        send(HttpMethod.PUT, callback, newAgreementFile);
    }

    /**
     * Creates a AgreementFile with a new object
     *
     * @param newAgreementFile the object to create/update
     * @return the created AgreementFile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AgreementFile put(final AgreementFile newAgreementFile) throws ClientException {
        return send(HttpMethod.PUT, newAgreementFile);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IAgreementFileRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (AgreementFileRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IAgreementFileRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (AgreementFileRequest)this;
     }

}

