// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.PrintUsageByPrinter;
import com.microsoft.graph.models.extensions.PrintUsageByUser;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.PrintUsageByPrinterCollectionPage;
import com.microsoft.graph.requests.extensions.PrintUsageByUserCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Report Root.
 */
public class ReportRoot extends Entity implements IJsonBackedObject {


    /**
     * The Daily Print Usage By Printer.
     * 
     */
    @SerializedName(value = "dailyPrintUsageByPrinter", alternate = {"DailyPrintUsageByPrinter"})
    @Expose
    public PrintUsageByPrinterCollectionPage dailyPrintUsageByPrinter;

    /**
     * The Daily Print Usage By User.
     * 
     */
    @SerializedName(value = "dailyPrintUsageByUser", alternate = {"DailyPrintUsageByUser"})
    @Expose
    public PrintUsageByUserCollectionPage dailyPrintUsageByUser;

    /**
     * The Monthly Print Usage By Printer.
     * 
     */
    @SerializedName(value = "monthlyPrintUsageByPrinter", alternate = {"MonthlyPrintUsageByPrinter"})
    @Expose
    public PrintUsageByPrinterCollectionPage monthlyPrintUsageByPrinter;

    /**
     * The Monthly Print Usage By User.
     * 
     */
    @SerializedName(value = "monthlyPrintUsageByUser", alternate = {"MonthlyPrintUsageByUser"})
    @Expose
    public PrintUsageByUserCollectionPage monthlyPrintUsageByUser;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("dailyPrintUsageByPrinter")) {
            dailyPrintUsageByPrinter = serializer.deserializeObject(json.get("dailyPrintUsageByPrinter").toString(), PrintUsageByPrinterCollectionPage.class);
        }

        if (json.has("dailyPrintUsageByUser")) {
            dailyPrintUsageByUser = serializer.deserializeObject(json.get("dailyPrintUsageByUser").toString(), PrintUsageByUserCollectionPage.class);
        }

        if (json.has("monthlyPrintUsageByPrinter")) {
            monthlyPrintUsageByPrinter = serializer.deserializeObject(json.get("monthlyPrintUsageByPrinter").toString(), PrintUsageByPrinterCollectionPage.class);
        }

        if (json.has("monthlyPrintUsageByUser")) {
            monthlyPrintUsageByUser = serializer.deserializeObject(json.get("monthlyPrintUsageByUser").toString(), PrintUsageByUserCollectionPage.class);
        }
    }
}
