// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.PrintJobConfiguration;
import com.microsoft.graph.models.extensions.UserIdentity;
import com.microsoft.graph.models.extensions.PrintJobStatus;
import com.microsoft.graph.models.extensions.PrintDocument;
import com.microsoft.graph.models.extensions.PrintTask;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.PrintDocumentCollectionPage;
import com.microsoft.graph.requests.extensions.PrintTaskCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Job.
 */
public class PrintJob extends Entity implements IJsonBackedObject {


    /**
     * The Configuration.
     * A group of settings that a printer should use to print a job.
     */
    @SerializedName(value = "configuration", alternate = {"Configuration"})
    @Expose
    public PrintJobConfiguration configuration;

    /**
     * The Created By.
     * Read-only. Nullable.
     */
    @SerializedName(value = "createdBy", alternate = {"CreatedBy"})
    @Expose
    public UserIdentity createdBy;

    /**
     * The Created Date Time.
     * The DateTimeOffset when the job was created. Read-only.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
    public java.util.Calendar createdDateTime;

    /**
     * The Is Fetchable.
     * If true, document can be fetched by printer.
     */
    @SerializedName(value = "isFetchable", alternate = {"IsFetchable"})
    @Expose
    public Boolean isFetchable;

    /**
     * The Redirected From.
     * Contains the source job URL, if the job has been redirected from another printer.
     */
    @SerializedName(value = "redirectedFrom", alternate = {"RedirectedFrom"})
    @Expose
    public String redirectedFrom;

    /**
     * The Redirected To.
     * Contains the destination job URL, if the job has been redirected to another printer.
     */
    @SerializedName(value = "redirectedTo", alternate = {"RedirectedTo"})
    @Expose
    public String redirectedTo;

    /**
     * The Status.
     * The status of the print job. Read-only.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
    public PrintJobStatus status;

    /**
     * The Documents.
     * Read-only.
     */
    @SerializedName(value = "documents", alternate = {"Documents"})
    @Expose
    public PrintDocumentCollectionPage documents;

    /**
     * The Tasks.
     * A list of printTasks that were triggered by this print job.
     */
    @SerializedName(value = "tasks", alternate = {"Tasks"})
    @Expose
    public PrintTaskCollectionPage tasks;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("documents")) {
            documents = serializer.deserializeObject(json.get("documents").toString(), PrintDocumentCollectionPage.class);
        }

        if (json.has("tasks")) {
            tasks = serializer.deserializeObject(json.get("tasks").toString(), PrintTaskCollectionPage.class);
        }
    }
}
