/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.models.extensions.Attachment;
import com.microsoft.graph.requests.extensions.AttachmentCollectionPage;
import com.microsoft.graph.requests.extensions.AttachmentCollectionResponse;
import com.microsoft.graph.serializer.DefaultSerializer;
import java.util.Arrays;
import java.util.List;

public class AttachmentCollectionPageSerializer {
    private static DefaultSerializer serializer;

    private AttachmentCollectionPageSerializer() {
    }

    public static JsonElement serialize(AttachmentCollectionPage src, ILogger logger) {
        if (src == null) {
            return null;
        }
        JsonArray jsonArray = new JsonArray();
        List attachments = src.getCurrentPage();
        serializer = new DefaultSerializer(logger);
        for (Attachment attachment : attachments) {
            JsonObject jsonObject = new JsonObject();
            String json = serializer.serializeObject(attachment);
            jsonObject = (JsonObject)JsonParser.parseString((String)json);
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray;
    }

    public static AttachmentCollectionPage deserialize(JsonElement json, ILogger logger) throws JsonParseException {
        if (json == null) {
            return null;
        }
        AttachmentCollectionResponse response = new AttachmentCollectionResponse();
        serializer = new DefaultSerializer(logger);
        JsonObject[] sourceArray = serializer.deserializeObject(json.toString(), JsonObject[].class);
        Attachment[] array = new Attachment[sourceArray.length];
        for (int i = 0; i < sourceArray.length; ++i) {
            array[i] = serializer.deserializeObject(sourceArray[i].toString(), Attachment.class);
            array[i].setRawObject(serializer, sourceArray[i]);
        }
        response.value = Arrays.asList(array);
        return new AttachmentCollectionPage(response, null);
    }
}

