/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.WorkbookComment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IWorkbookCommentCollectionPage;
import com.microsoft.graph.requests.extensions.IWorkbookCommentCollectionRequest;
import com.microsoft.graph.requests.extensions.WorkbookCommentCollectionPage;
import com.microsoft.graph.requests.extensions.WorkbookCommentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookCommentCollectionResponse;
import com.microsoft.graph.requests.extensions.WorkbookCommentRequestBuilder;
import java.util.List;

public class WorkbookCommentCollectionRequest
extends BaseCollectionRequest<WorkbookCommentCollectionResponse, IWorkbookCommentCollectionPage>
implements IWorkbookCommentCollectionRequest {
    public WorkbookCommentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookCommentCollectionResponse.class, IWorkbookCommentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWorkbookCommentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(WorkbookCommentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkbookCommentCollectionPage get() throws ClientException {
        WorkbookCommentCollectionResponse response = (WorkbookCommentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkbookComment newWorkbookComment, ICallback<WorkbookComment> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkbookCommentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkbookComment, callback);
    }

    @Override
    public WorkbookComment post(WorkbookComment newWorkbookComment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkbookCommentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkbookComment);
    }

    @Override
    public IWorkbookCommentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IWorkbookCommentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IWorkbookCommentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IWorkbookCommentCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IWorkbookCommentCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IWorkbookCommentCollectionPage buildFromResponse(WorkbookCommentCollectionResponse response) {
        WorkbookCommentCollectionRequestBuilder builder = response.nextLink != null ? new WorkbookCommentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkbookCommentCollectionPage page = new WorkbookCommentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

