/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.WorkbookChartPoint;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IWorkbookChartPointCollectionPage;
import com.microsoft.graph.requests.extensions.IWorkbookChartPointCollectionRequest;
import com.microsoft.graph.requests.extensions.WorkbookChartPointCollectionPage;
import com.microsoft.graph.requests.extensions.WorkbookChartPointCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartPointCollectionResponse;
import com.microsoft.graph.requests.extensions.WorkbookChartPointRequestBuilder;
import java.util.List;

public class WorkbookChartPointCollectionRequest
extends BaseCollectionRequest<WorkbookChartPointCollectionResponse, IWorkbookChartPointCollectionPage>
implements IWorkbookChartPointCollectionRequest {
    public WorkbookChartPointCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookChartPointCollectionResponse.class, IWorkbookChartPointCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWorkbookChartPointCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(WorkbookChartPointCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkbookChartPointCollectionPage get() throws ClientException {
        WorkbookChartPointCollectionResponse response = (WorkbookChartPointCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkbookChartPoint newWorkbookChartPoint, ICallback<WorkbookChartPoint> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkbookChartPointRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkbookChartPoint, callback);
    }

    @Override
    public WorkbookChartPoint post(WorkbookChartPoint newWorkbookChartPoint) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkbookChartPointRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkbookChartPoint);
    }

    @Override
    public IWorkbookChartPointCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IWorkbookChartPointCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IWorkbookChartPointCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IWorkbookChartPointCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IWorkbookChartPointCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IWorkbookChartPointCollectionPage buildFromResponse(WorkbookChartPointCollectionResponse response) {
        WorkbookChartPointCollectionRequestBuilder builder = response.nextLink != null ? new WorkbookChartPointCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkbookChartPointCollectionPage page = new WorkbookChartPointCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

