/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.WebApp;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IWebAppRequest;
import java.util.List;

public class WebAppRequest
extends BaseRequest
implements IWebAppRequest {
    public WebAppRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WebApp.class);
    }

    @Override
    public void get(ICallback<WebApp> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public WebApp get() throws ClientException {
        return (WebApp)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<WebApp> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(WebApp sourceWebApp, ICallback<WebApp> callback) {
        this.send(HttpMethod.PATCH, callback, sourceWebApp);
    }

    @Override
    public WebApp patch(WebApp sourceWebApp) throws ClientException {
        return (WebApp)this.send(HttpMethod.PATCH, sourceWebApp);
    }

    @Override
    public void post(WebApp newWebApp, ICallback<WebApp> callback) {
        this.send(HttpMethod.POST, callback, newWebApp);
    }

    @Override
    public WebApp post(WebApp newWebApp) throws ClientException {
        return (WebApp)this.send(HttpMethod.POST, newWebApp);
    }

    @Override
    public void put(WebApp newWebApp, ICallback<WebApp> callback) {
        this.send(HttpMethod.PUT, callback, newWebApp);
    }

    @Override
    public WebApp put(WebApp newWebApp) throws ClientException {
        return (WebApp)this.send(HttpMethod.PUT, newWebApp);
    }

    @Override
    public IWebAppRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IWebAppRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

